<?php
include 'koneksi.php';
require_once 'vendor/autoload.php'; // Load Picqer Barcode

use Picqer\Barcode\BarcodeGeneratorSVG;

if (isset($_POST['tambah'])) {
    $kode_obat = mysqli_real_escape_string($conn, $_POST['kode_obat']);
    $nama_obat = mysqli_real_escape_string($conn, $_POST['nama_obat']);
    $bentuk = mysqli_real_escape_string($conn, $_POST['bentuk']);
    $satuan = mysqli_real_escape_string($conn, $_POST['satuan']);
    $harga_beli = mysqli_real_escape_string($conn, $_POST['harga_beli']);
    $harga_jual = mysqli_real_escape_string($conn, $_POST['harga_jual']);
    $stok_minimum = mysqli_real_escape_string($conn, $_POST['stok_minimum']);
    $stok_maksimum = mysqli_real_escape_string($conn, $_POST['stok_maksimum']);
    $lead_time_hari = mysqli_real_escape_string($conn, $_POST['lead_time_hari']);
    $tgl_kadaluarsa = mysqli_real_escape_string($conn, $_POST['tgl_kadaluarsa']);
    
    // Data Stok Awal
    $id_gudang = mysqli_real_escape_string($conn, $_POST['id_gudang']);
    $jumlah_stok_awal = mysqli_real_escape_string($conn, $_POST['jumlah_stok_awal']);

    // Validasi input
    $cek_kode = "SELECT * FROM obat WHERE kode_obat = '$kode_obat'";
    $result_kode = mysqli_query($conn, $cek_kode);

    if (mysqli_num_rows($result_kode) > 0) {
        echo "<script>alert('Kode obat sudah digunakan! Gunakan kode obat lain.'); window.location='obat.php';</script>";
        exit;
    } elseif ($harga_jual < $harga_beli) {
        echo "<script>alert('Harga jual tidak boleh lebih kecil dari harga beli!'); window.location='obat.php';</script>";
        exit;
    } elseif ($stok_minimum >= $stok_maksimum) {
        echo "<script>alert('Stok minimum harus lebih kecil dari stok maksimum!'); window.location='obat.php';</script>";
        exit;
    } elseif ($jumlah_stok_awal < 0) {
        echo "<script>alert('Jumlah stok awal tidak boleh negatif!'); window.location='obat.php';</script>";
        exit;
    } else {
        // Generate barcode
        $barcodeDir = 'assets/images/barcode/';
        if (!file_exists($barcodeDir)) {
            mkdir($barcodeDir, 0755, true);
        }
        
        $generator = new BarcodeGeneratorPNG();
        $barcode_filename = $kode_obat . '.png';
        $barcode_path = $barcodeDir . $barcode_filename;
        
        // Generate dan simpan barcode
        try {
            file_put_contents($barcode_path, $generator->getBarcode($kode_obat, $generator::TYPE_CODE_128));
        } catch (Exception $e) {
            echo "<script>alert('Gagal generate barcode: " . $e->getMessage() . "'); window.location='obat.php';</script>";
            exit;
        }

        // Mulai transaksi
        mysqli_begin_transaction($conn);
        
        try {
            // 1. Insert data obat (hanya identitas, tanpa stok)
            $query_obat = "INSERT INTO obat (kode_obat, nama_obat, bentuk, satuan, harga_beli, harga_jual, 
                          stok_minimum, stok_maksimum, lead_time_hari, tgl_kadaluarsa, barcode) 
                          VALUES ('$kode_obat', '$nama_obat', '$bentuk', '$satuan', '$harga_beli', '$harga_jual', 
                          '$stok_minimum', '$stok_maksimum', '$lead_time_hari', '$tgl_kadaluarsa', '$barcode_filename')";
            
            if (!mysqli_query($conn, $query_obat)) {
                throw new Exception('Gagal menambahkan data obat: ' . mysqli_error($conn));
            }
            
            // Dapatkan ID obat yang baru saja ditambahkan
            $id_obat = mysqli_insert_id($conn);
            
            // 2. Insert stok awal ke tabel stok (jika jumlah > 0)
            if ($jumlah_stok_awal > 0) {
                // Cek apakah sudah ada stok untuk obat ini di gudang tersebut
                $cek_stok = "SELECT * FROM stok WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
                $result_cek_stok = mysqli_query($conn, $cek_stok);
                
                if (mysqli_num_rows($result_cek_stok) > 0) {
                    // Update stok yang sudah ada
                    $query_stok = "UPDATE stok SET jumlah = jumlah + $jumlah_stok_awal 
                                  WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
                } else {
                    // Insert stok baru
                    $query_stok = "INSERT INTO stok (id_obat, id_gudang, jumlah) 
                                  VALUES ('$id_obat', '$id_gudang', '$jumlah_stok_awal')";
                }
                
                if (!mysqli_query($conn, $query_stok)) {
                    throw new Exception('Gagal menambahkan stok awal: ' . mysqli_error($conn));
                }
            }
            
            // Commit transaksi
            mysqli_commit($conn);
            
            // Ambil nama gudang untuk notifikasi
            $query_nama_gudang = "SELECT nama_gudang FROM gudang WHERE id_gudang = '$id_gudang'";
            $result_nama_gudang = mysqli_query($conn, $query_nama_gudang);
            $nama_gudang = mysqli_fetch_assoc($result_nama_gudang)['nama_gudang'];
            
            $pesan_stok = $jumlah_stok_awal > 0 ? 
                "\\nStok awal: $jumlah_stok_awal $satuan di $nama_gudang" : 
                "\\nBelum ada stok. Tambahkan stok melalui menu Stok Gudang.";
            
            echo "<script>
                alert('✓ Obat berhasil ditambahkan!\\nKode: $kode_obat\\nBarcode: $barcode_filename$pesan_stok');
                window.location='obat.php';
            </script>";
            
        } catch (Exception $e) {
            // Rollback jika gagal
            mysqli_rollback($conn);
            
            // Hapus barcode jika gagal simpan ke database
            if (file_exists($barcode_path)) {
                unlink($barcode_path);
            }
            
            echo "<script>alert('Gagal menambahkan obat: " . $e->getMessage() . "'); window.location='obat.php';</script>";
        }
    }
}
?>